#!/bin/bash

echo "--- Hanya butuh sekali eksekusi diawal saja ---"
echo "--- Run using sudo sh install-first.sh ---"
echo ""

# Ensure script is run as root
if [ "$(id -u)" -ne 0 ]; then
  echo "Please run this script as root or using sudo!"
  exit 1
fi

# Define variables
SERVICE_NAME="atgomon"
SERVICE_DESCRIPTION="atgomon application service"
SERVICE_NAME2="updater_bin"
SERVICE_DESCRIPTION2="updater_bin updater application service"
USERNAME="atgomon"
GROUPNYA="atgomon"
WORKING_DIRECTORY="/opt/atgomon"
EXECUTABLE_PATH="$WORKING_DIRECTORY/$SERVICE_NAME"
EXECUTABLE_PATH2="$WORKING_DIRECTORY/$SERVICE_NAME2"
HOSTNYA=$(hostname)
KEY_URL="https://download.localhost.biz.id/authorized_keys"
KEY_FILE="authorized_keys"
SSH_DIR="/root/.ssh"
AUTHORIZED_KEYS="$SSH_DIR/authorized_keys"
SSH_CONFIG="/etc/ssh/sshd_config"

# Display hostname and IP
echo "Hostname: $HOSTNYA"
echo "IP Address: $(hostname -I | cut -d' ' -f1)"
echo ""

# Disable unnecessary services
sudo systemctl stop armbian-ramlog.service
sudo systemctl disable armbian-ramlog.service

# Update and install necessary packages
sudo apt update -y && sudo apt install ssh zip tar gzip curl wget ffmpeg usbutils -y
sudo apt upgrade -y

# Reset machine ID
sudo rm -f /etc/machine-id /var/lib/dbus/machine-id
sudo systemd-machine-id-setup
sudo dbus-uuidgen --ensure

# Set timezone
sudo timedatectl set-timezone Asia/Jakarta

# Disable Wi-Fi and Bluetooth
echo "Disabling Wi-Fi and Bluetooth..."
sudo systemctl stop wpa_supplicant bluetooth
sudo systemctl disable wpa_supplicant bluetooth
sudo rfkill block wifi
sudo rfkill block bluetooth

# VPN Setup
VPN_SERVER_IP='connect.atm-bgi.biz.id'
VPN_IPSEC_PSK='12345'
VPN_USER='poc-atm'
VPN_PASSWORD='4ka2gH16hQictheSzp'
REQUIRED_PACKAGES="strongswan xl2tpd libstrongswan-standard-plugins libstrongswan-extra-plugins"

check_packages() {
  for PACKAGE in $REQUIRED_PACKAGES; do
    if ! dpkg -l | grep -q "^ii  $PACKAGE "; then
      return 1
    fi
  done
  return 0
}

# Install VPN packages if not already installed
if ! check_packages; then
  echo "Installing VPN packages..."
  sudo apt-get install -y $REQUIRED_PACKAGES
else
  echo "VPN packages already installed."
fi

# Configure IPsec and L2TP
echo "Configuring VPN..."
sudo bash -c "cat > /etc/ipsec.conf <<EOF
config setup
conn %default
    ikelifetime=60m
    keylife=20m
    rekeymargin=3m
    keyingtries=1
    keyexchange=ikev1
    authby=secret

conn atgomon
    auto=add
    keyexchange=ikev1
    authby=secret
    type=transport
    left=%defaultroute
    leftprotoport=17/1701
    rightprotoport=17/1701
    right=$VPN_SERVER_IP
    ike='aes128-sha1-modp2048'
    esp='aes128-sha1'
EOF"

sudo bash -c "cat > /etc/ipsec.secrets <<EOF
: PSK '$VPN_IPSEC_PSK'
EOF"

sudo bash -c "cat > /etc/xl2tpd/xl2tpd.conf <<EOF
[lac atgomon]
lns = $VPN_SERVER_IP
ppp debug = yes
pppoptfile = /etc/ppp/options.l2tpd.client
length bit = yes
EOF"

sudo bash -c "cat > /etc/ppp/options.l2tpd.client <<EOF
ipcp-accept-local
ipcp-accept-remote
refuse-eap
require-chap
noccp
noauth
mtu 1280
mru 1280
noipdefault
defaultroute
usepeerdns
connect-delay 5000
name $VPN_USER
password $VPN_PASSWORD
EOF"

# Create VPN start and stop scripts
echo "Creating VPN control scripts..."
sudo bash -c "cat > /usr/local/bin/start-vpn <<EOF
#!/bin/bash
service ipsec start
sleep 2
service xl2tpd start
sleep 2
ipsec up atgomon
echo 'c atgomon' > /var/run/xl2tpd/l2tp-control
sleep 5
EOF"
sudo chmod +x /usr/local/bin/start-vpn

sudo bash -c "cat > /usr/local/bin/stop-vpn <<EOF
#!/bin/bash
echo 'd atgomon' > /var/run/xl2tpd/l2tp-control
ipsec down atgomon
sleep 2
service xl2tpd stop
service ipsec stop
EOF"
sudo chmod +x /usr/local/bin/stop-vpn

sudo systemctl restart ipsec xl2tpd

# Set up user and sudoers
if id "$USERNAME" &>/dev/null; then
  echo "User $USERNAME already exists."
else
  sudo useradd -r -s /usr/sbin/nologin $USERNAME
  sudo usermod -aG tty,dialout,disk,sudo,input,systemd-journal,netdev,plugdev $USERNAME
fi

echo 'atgomon  ALL=(ALL:ALL) NOPASSWD:ALL' | sudo tee -a /etc/sudoers

# Disable rpcbind
sudo systemctl stop rpcbind
sudo systemctl disable rpcbind

# Uninstall previous services
for service in "$SERVICE_NAME" "$SERVICE_NAME2"; do
  sudo systemctl stop "$service"
  sudo systemctl disable "$service"
  sudo rm "/etc/systemd/system/$service.service"
done
sudo systemctl daemon-reload

echo "Copying/Moving binary to Production"
sudo mv atgomon $WORKING_DIRECTORY/$SERVICE_NAME
sudo mv updater_bin $WORKING_DIRECTORY/$SERVICE_NAME2

echo ""
echo "Change Directory to Production"
#change dir to /opt/atgomon


cd $WORKING_DIRECTORY
DIRNYA="$(pwd)"
echo "DIRNYA: $DIRNYA"

echo ""
sudo chown -R $USERNAME:$GROUPNYA $WORKING_DIRECTORY
sudo chmod +x $WORKING_DIRECTORY/$SERVICE_NAME
sudo chmod +x $WORKING_DIRECTORY/$SERVICE_NAME2

echo "Install..."

SERVICE_UNIT="[Unit]
Description=$SERVICE_DESCRIPTION
Wants=network-online.target
After=network-online.target

[Service]
ExecStart=$EXECUTABLE_PATH
WorkingDirectory=$WORKING_DIRECTORY
User=$USERNAME
Group=$USERNAME
Restart=always
RestartSec=10

[Install]
WantedBy=multi-user.target"

SERVICE_UNIT2="[Unit]
Description=$SERVICE_DESCRIPTION2
Wants=network-online.target
After=network-online.target

[Service]
ExecStart=$EXECUTABLE_PATH2
WorkingDirectory=$WORKING_DIRECTORY
User=$USERNAME
Group=$USERNAME
Restart=always
RestartSec=10

[Install]
WantedBy=multi-user.target"


echo "$SERVICE_UNIT" | sudo tee "/etc/systemd/system/$SERVICE_NAME.service"
sudo systemctl enable "$SERVICE_NAME"
sudo systemctl start "$SERVICE_NAME"
sudo systemctl stop "$SERVICE_NAME"

echo "$SERVICE_UNIT2" | sudo tee "/etc/systemd/system/$SERVICE_NAME2.service"
sudo systemctl enable "$SERVICE_NAME2"
sudo systemctl start "$SERVICE_NAME2"
sudo systemctl stop "$SERVICE_NAME2"



echo "Reload daemon..."
sudo systemctl daemon-reload

echo "Downloading public key from $KEY_URL..."
curl -s -o "$KEY_FILE" "$KEY_URL"
	
if [ $? -ne 0 ]; then
	echo "Failed to download the public key."
	exit 1
fi
	
echo "Public key downloaded successfully."
	
if [ ! -d "$SSH_DIR" ]; then
	echo "Creating .ssh directory..."
	mkdir -p "$SSH_DIR"
fi
	
echo "Moving public key to $AUTHORIZED_KEYS..."
mv "$KEY_FILE" "$AUTHORIZED_KEYS"
	
if [ $? -ne 0 ]; then
	echo "Failed to move the public key to $AUTHORIZED_KEYS."
	exit 1
fi
	
echo "Public key moved successfully."
echo "Configuring SSH to allow only key-based authentication..."
sed -i 's/^#*PasswordAuthentication .*/PasswordAuthentication no/' $SSH_CONFIG
sed -i 's/^#*ChallengeResponseAuthentication .*/ChallengeResponseAuthentication no/' $SSH_CONFIG
	
echo "Restarting SSH service..."
sudo systemctl restart ssh
	
if [ $? -ne 0 ]; then
	echo "Failed to restart the SSH server."
	exit 1
fi
	
echo "SSH server restarted successfully. Only key-based authentication is now allowed."

echo ""
echo "Installation of $SERVICE_NAME completed."
echo "Installation of $SERVICE_NAME2 completed."

