#!/bin/bash

echo "--- Initial setup, only run once ---"
echo "--- Run using sudo: sudo sh network-setup.sh ---"
echo ""

# Check if the script is being run as root
if [ "$(id -u)" -ne 0 ]; then
  echo "Please run this script as root or using sudo!"
  exit 1
fi

# Clean and Remove Desktop Packages
echo ""
echo "--------------------------------------------------"
echo "Choose:"
echo "1) Clean and Remove All Desktop Packages"
echo "2) Exit"
echo "Press any other key to skip and continue..."
read -p "Enter choice [1-2]: " choice

case $choice in
  1)
    echo "Cleaning and Removing All Desktop Packages..."
    packages="desktop gnome kde xfce lxde lxqt mate cinnamon unity lightdm sddm gdm3 kdm xserver wayland x11 xorg xterm xinit xauth xhost xinput xkb xmodmap xrandr xset xsetroot xvfb xwd xwininfo xwud xev xkill xlogo xmag xmessage xprop xvinfo xcalc xclipboard xconsole xcursorgen xditview xedit xfontsel xload nfs samba firefox chromium opera midori epiphany lynx links"
    
    for pkg in $packages; do
      echo "Removing package: $pkg"
      sudo apt remove --purge -y *$pkg*
    done
    
    sudo apt purge -y $(dpkg --list | grep '^rc' | awk '{print $2}')
    sudo apt autoremove --purge -y
    sudo apt clean
    ;;
  2)
    echo "Exiting..."
    exit 0
    ;;
  *)
    echo "Skipped clean."
    ;;
esac

# Remove All Non-System Users
echo ""
echo "--------------------------------------------------"
echo "Choose:"
echo "1) Remove All Non-System Users"
echo "2) Exit"
echo "Press any other key to skip and continue..."
read -p "Enter choice [1-2]: " choice

case $choice in
  1)
    echo "Removing All Non-System Users..."
    all_users=$(cut -d: -f1 /etc/passwd)
    system_users="root daemon bin sys sync games man lp mail news uucp proxy www-data backup list irc gnats nobody _apt systemd-network systemd-resolve messagebus vnstat _rpc avahi-autoipd statd _chrony systemd-timesync systemd-coredump syslog strongswan"
    
    for user in $all_users; do
      if ! echo "$system_users" | grep -qw "$user"; then
        echo "Removing user: $user"
        sudo deluser --remove-home "$user"
      fi
    done
    ;;
  2)
    echo "Exiting..."
    exit 0
    ;;
  *)
    echo "Skipped user removal."
    ;;
esac


# Remove Unused Services
echo ""
echo "--------------------------------------------------"
echo "Choose:"
echo "1) Remove Unused Services"
echo "2) Exit"
echo "Press any other key to skip and continue..."
read -p "Enter choice [1-2]: " choice

case $choice in
  1)
    echo "Removing unused services..."
    essential_services="alsa-restore.service alsa-state.service apt-daily.service systemd-logind.service rsyslog.service"
    all_services=$(systemctl list-unit-files --type=service --no-pager --no-legend | awk '{print $1}')
    
    for service in $all_services; do
      if ! echo "$essential_services" | grep -qw "$service"; then
        echo "Disabling and stopping service: $service"
        sudo systemctl stop "$service"
        sudo systemctl disable "$service"
      fi
    done
    ;;
  2)
    echo "Exiting..."
    exit 0
    ;;
  *)
    echo "Skipped service removal."
    ;;
esac

# Identify Manually Installed Packages
echo ""
echo "--------------------------------------------------"
echo "Choose:"
echo "1) Identify Manually Installed Packages"
echo "2) Exit"
echo "Press any other key to skip and continue..."
read -p "Enter choice [1-2]: " choice

case $choice in
  1)
    echo "Identifying manually installed packages..."
    dpkg --get-selections | grep -v deinstall
    sudo apt list --installed
    sudo apt clean
    ;;
  2)
    echo "Exiting..."
    exit 0
    ;;
  *)
    echo "Skipped manual package identification."
    ;;
esac

# Final Cleanup and Autoremove
sudo apt autoremove --purge -y
sudo apt clean

# Reboot Option
echo ""
echo "--------------------------------------------------"
echo "Select Next Action:"
echo "1) Reboot"
echo "2) Exit"
read -p "Enter choice [1-2]: " choice

case $choice in
  1)
    echo "Rebooting system..."
    sudo reboot
    ;;
  2)
    echo "Exiting script."
    exit 0
    ;;
  *)
    echo "Skipped reboot."
    ;;
esac
